/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast.util;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.parser.block.BlockParser;
import icyllis.flexmark.parser.block.BlockParserTracker;
import icyllis.flexmark.util.ast.Block;
import icyllis.flexmark.util.ast.BlockTracker;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeClassifier;
import icyllis.flexmark.util.collection.ClassificationBag;
import icyllis.flexmark.util.collection.CollectionHost;
import icyllis.flexmark.util.collection.OrderedMultiMap;
import icyllis.flexmark.util.collection.OrderedSet;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import icyllis.flexmark.util.misc.Paired;

public class ClassifyingBlockTracker
implements BlockTracker,
BlockParserTracker {
    protected final ClassificationBag<Class<?>, Node> nodeClassifier = new ClassificationBag(NodeClassifier.INSTANCE);
    protected final OrderedMultiMap<BlockParser, Block> allBlockParsersMap = new OrderedMultiMap<BlockParser, Block>(new CollectionHost<Paired<BlockParser, Block>>(){

        @Override
        public void adding(int index, @Nullable Paired<BlockParser, Block> paired, @Nullable Object v) {
            Block block = paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.add(block);
            }
        }

        @Override
        public Object removing(int index, @Nullable Paired<BlockParser, Block> paired) {
            Block block = paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.remove(block);
            }
            return paired;
        }

        @Override
        public void clearing() {
            ClassifyingBlockTracker.this.nodeClassifier.clear();
        }

        @Override
        public void addingNulls(int index) {
        }

        @Override
        public boolean skipHostUpdate() {
            return false;
        }

        @Override
        public int getIteratorModificationCount() {
            return ClassifyingBlockTracker.this.allBlockParsersMap.getModificationCount();
        }
    });

    public OrderedSet<BlockParser> allBlockParsers() {
        return this.allBlockParsersMap.keySet();
    }

    public OrderedSet<Block> allBlocks() {
        return this.allBlockParsersMap.valueSet();
    }

    public Block getValue(BlockParser parser) {
        return this.allBlockParsersMap.getKeyValue(parser);
    }

    public BlockParser getKey(Block parser) {
        return this.allBlockParsersMap.getValueKey(parser);
    }

    public boolean containsKey(BlockParser parser) {
        return this.allBlockParsersMap.containsKey(parser);
    }

    public boolean containsValue(Block parser) {
        return this.allBlockParsersMap.containsValue(parser);
    }

    public ClassificationBag<Class<?>, Node> getNodeClassifier() {
        return this.nodeClassifier;
    }

    @Override
    public void blockParserAdded(BlockParser blockParser) {
        this.allBlockParsersMap.putKeyValue(blockParser, blockParser.getBlock());
    }

    @Override
    public void blockParserRemoved(BlockParser blockParser) {
        this.allBlockParsersMap.removeKey(blockParser);
    }

    private void validateLinked(Node node) {
        if (node.getNext() == null && node.getParent() == null) {
            throw new IllegalStateException("Added block " + node + " is not linked into the AST");
        }
    }

    @Override
    public void blockAdded(@NotNull Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
    }

    @Override
    public void blockAddedWithChildren(@NotNull Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
        this.addBlocks(node.getChildren());
    }

    @Override
    public void blockAddedWithDescendants(@NotNull Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
        this.addBlocks(node.getDescendants());
    }

    private void addBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.putValueKey((Block)child, null);
        }
    }

    private void validateUnlinked(Node node) {
        if (node.getNext() != null || node.getParent() != null) {
            throw new IllegalStateException("Removed block " + node + " is still linked in the AST");
        }
    }

    @Override
    public void blockRemoved(@NotNull Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
    }

    @Override
    public void blockRemovedWithChildren(@NotNull Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
        this.removeBlocks(node.getChildren());
    }

    @Override
    public void blockRemovedWithDescendants(@NotNull Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
        this.removeBlocks(node.getDescendants());
    }

    private void removeBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.removeValue(child);
        }
    }
}

